﻿//$.ui.autocomplete.filter = function (array, term) {

//    var searchOption = $(this).attr("data-searchoption");

//    var matcher = new RegExp("^" + $.ui.autocomplete.escapeRegex(term), "i");
//    return $.grep(array, function (value) {
//        return matcher.test(value.label || value.value || value);
//    });
//};


$(document).ready(function () {
    $(".autoComplete > input[type=text]").each(function () {
        var autoComplete = $(this);
        var context = autoComplete.closest(".questionContent");
        var choices = $(".choiceList select option:enabled", context).map(function () { return { value: $(this).val(), label: $(this).text().trim() }; }).get();
        var minSearchLength = autoComplete.attr("data-minsearchlength");
        var maxResults = autoComplete.attr("data-maxresults");
        var maxResultsMessage = autoComplete.attr("data-maxresultsmessage");
        var invalidAsOpenEnd = autoComplete.attr("data-invalidasopenend") == "true";
        var autoCompleteValue = $(".autoCompleteValue", context);
        var searchOption = autoComplete.attr("data-searchoption");

        autoComplete.autocomplete({
            source: function (request, response) {
                return filterAutoCompleteData(request, response, choices, searchOption);
            },
            minLength: minSearchLength,
            delay: 100,
            focus: function (event, ui) {
                if (ui.item && ui.item.label) {
                    $(this).val(ui.item.label);
                }
                return false;
            },
            change: function (event, ui) {
                selectAutoCompleteItem(ui, autoComplete, autoCompleteValue, invalidAsOpenEnd);
            },
            select: function (event, ui) {
                selectAutoCompleteItem(ui, autoComplete, autoCompleteValue, invalidAsOpenEnd);
                return false;
            },
            search: function (event, ui) {
                var clicked = autoComplete.attr("data-clicked") == 1;
                autoComplete.attr("data-clicked", 0);

                if (!clicked && autoComplete.val().trim().length == 0) {
                    autoComplete.autocomplete("close");
                    event.preventDefault();
                }
            },
            filter: function (array, term) {
                var matcher = new RegExp("^" + $.ui.autocomplete.escapeRegex(term), "i");
                return $.grep(array, function (value) {
                    return matcher.test(value.label || value.value || value);
                });
            }
        });

        autoComplete.data("ui-autocomplete")._renderItem = function (ul, item) {
            return $("<li>").data("ui-autocomplete-item", item).append("<a>" + item.label + "</a>").appendTo(ul);
        };

        autoComplete.data("ui-autocomplete")._renderMenu = function (ul, items) {
            var renderItemsCount = items.length;

            if (maxResults > 0) {
                renderItemsCount = Math.min(items.length, maxResults);
            }

            for (var index = 0; index < renderItemsCount ; index++) {
                this._renderItem(ul, items[index]);
            }

            if (renderItemsCount != items.length) {
                $("<li>", { "class": "ui-menu-item autocomplete-message", "style": "pointer-events:none;" }).append(maxResultsMessage.replace(/{max}/g, renderItemsCount)).appendTo(ul);
            }
        };

        autoComplete.on("keydown", function (event) {
            var keyCode = event.keyCode || event.which;
            if (keyCode == 13) {
                selectAutoCompleteItem(null, autoComplete, autoCompleteValue, invalidAsOpenEnd)
            }
        });

        autoComplete.attr("autocomplete", "nope"); // As of Chrome 79 autocomplete="off" will respect this tag for autocomplete data, but not respect it for autofill. The common workaround found on the Internet is to change the value for a random string - nope in this case. This way it disables Autocomplete and Autofill at the same time
    });

    $(".autoComplete > .autoCompleteButton").on("click", function () {
        var autoComplete = $(this).closest(".autoComplete").find("input[type=text]");
        autoComplete.attr("data-clicked", 1);
        autoComplete.autocomplete("search", "");
        autoComplete.focus();
    });
});

function filterAutoCompleteData(request, response, choices, searchOption) {
    if (request) {
        var matcher;
        if (searchOption == "Exact") {
            matcher = new RegExp("^" + $.ui.autocomplete.escapeRegex(request.term) + "$", "i");
        } else if (searchOption == "StartsWith") {
            matcher = new RegExp("^" + $.ui.autocomplete.escapeRegex(request.term), "i");
        } else {
            matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
        }

        var result = $.grep(choices, function (value) {
            return matcher.test(value.label || value.value || value);
        });

        if (response)
            response(result);
    }
    else
        return result;
}


function selectAutoCompleteItem(ui, autoComplete, autoCompleteValue, invalidAsOpenEnd) {
    if (ui && ui.item) {
        setAutoCompleteItem(ui.item, autoComplete, autoCompleteValue, invalidAsOpenEnd);
    }
    else {
        var source = autoComplete.autocomplete("option", "source");
        var term = autoComplete.val();
        source({ term: term }, function (result) {
            var regexp = new RegExp("^" + $.ui.autocomplete.escapeRegex(term) + "$", "i");
            var item = _.find(result, function (i) { return i.label.match(regexp); });
            setAutoCompleteItem(item, autoComplete, autoCompleteValue, invalidAsOpenEnd);
        });
    }
}

function setAutoCompleteItem(item, autoComplete, autoCompleteValue, invalidAsOpenEnd) {
    if (item) {
        autoComplete.val(item.label);
        autoCompleteValue.val(item.value);
    }
    else if (invalidAsOpenEnd) {
        autoCompleteValue.val(autoComplete.val());
    }
    else {
        autoComplete.val("");
        autoCompleteValue.val("");
    }

    autoCompleteValue.trigger("change");
}

function updateAllAutoCompletesData() {
    $(".autoComplete > input[type=text]").each(function () {
        var autoComplete = $(this);
        if (autoComplete.data("ui-autocomplete") != undefined) {
            var context = autoComplete.closest(".questionContent");
            var searchOption = autoComplete.attr("data-searchoption");
            var choices = $(".choiceList select option:enabled", context).map(function () { return { value: $(this).val(), label: $(this).text().trim() }; }).get();

            autoComplete.autocomplete("option", "source", 
                function (request, response) {
                    return filterAutoCompleteData(request, response, choices, searchOption);
                } );
        }
    });
}